<?php $__env->startSection('title','مدیریت مقادیر واحد'); ?>
<?php $__env->startSection('pageTitle','فهرست مقادیر واحد'); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-md-4">
            <form action="<?php echo e(route('admin.UnitsValue.store')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="card mb-5 mb-xl-8">

                    <div class="card-header border-0 pt-5">
                        <h3 class="card-title fw-bolder fs-3">
                            ثبت مقدار واحد
                        </h3>
                    </div>

                    <div class="card-body py-3">

                        
                        <div class="col-md-12">
                            <?php echo $__env->make('admin.__components.label', ['title' => 'واحد','required'=>1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="mb-5">
                                <select class="form-control" name="unit_id" required>
                                    <option value="">انتخاب کنید</option>
                                    <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($unit->id); ?>">
                                            <?php echo e($unit->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        
                        <div class="col-md-12">
                            <?php echo $__env->make('admin.__components.label', ['title'=>'عنوان','required'=>1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="mb-5">
                                <?php echo $__env->make('admin.__components.input-text', [
                                    'name'=>'title',
                                    'placeholder'=>'مثلا 10 گرم'
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>

                        
                        <div class="col-md-12">
                            <?php echo $__env->make('admin.__components.label', ['title'=>'مقدار عددی'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <div class="mb-5">
                                <input type="number" step="0.001" name="value" class="form-control"
                                       placeholder="مثلا 10 یا 1000">
                                <small class="text-muted">
                                    برای تعداد خالی بگذارید
                                </small>
                            </div>
                        </div>

                    </div>

                    <div class="card-footer text-end">
                        <button type="submit" class="btn btn-light-success">
                            <i class="fa fa-plus"></i>
                            ثبت مقدار
                        </button>
                    </div>

                </div>
            </form>
        </div>

        
        <div class="col-md-8">
            <div class="card mb-5 mb-xl-8">

                <div class="card-header border-0 pt-5">
                    <h3 class="card-title fw-bolder fs-3">
                        فهرست مقادیر واحد
                    </h3>
                </div>

                <div class="card-body py-3">
                    <div class="table-responsive">
                        <table class="table align-middle gy-4">
                            <thead>
                            <tr class="fw-bolder text-muted bg-light">
                                <th>#</th>
                                <th>واحد</th>
                                <th>عنوان</th>
                                <th>مقدار</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php $__empty_1 = true; $__currentLoopData = $unitValues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->id); ?></td>
                                    <td><?php echo e($item->unit->name); ?></td>
                                    <td><?php echo e($item->title); ?></td>
                                    <td>
                                        <?php echo e($item->value ?? '-'); ?>

                                    </td>
                                    <td>
                                        <a data-id="<?php echo e($item->id); ?>"
                                           class="btn btn-light-danger btn-sm delete-confirm">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-danger">
                                        اطلاعاتی ثبت نشده است
                                    </td>
                                </tr>
                            <?php endif; ?>

                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <!--Begin : SweetAlert Flash Messages -->
    <script>
        // success message
        <?php if((session('success'))): ?>
        Swal.fire({
            icon: 'success',
            title: 'عملیات موفق',
            text: "<?php echo e((session('success'))); ?>",
            confirmButtonText: "متوجه شدم"
        })
        <?php endif; ?>
        // error message
        <?php if((session('failed'))): ?>
        Swal.fire({
            icon: 'error',
            title: 'خطا',
            text: "<?php echo e(session('failed')); ?>",
            confirmButtonText: "متوجه شدم"
        })
        <?php endif; ?>
    </script>
    <!--End : SweetAlert Flash Messages -->


    <script>
        $('.delete-confirm').on('click', function (event) {
            event.preventDefault();
            let id = $(this).data("id");
            let url = "<?php echo e(route('admin.UnitsValue.delete',":id")); ?>";
            url = url.replace(":id", id);

            Swal.fire({
                title: 'حذف  !',
                text: "آیا مطمئن هستید ؟",
                icon: "error",
                showCancelButton: true,
                confirmButtonColor: 'red',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'بله,حذف کن',
                cancelButtonText: 'خیر',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\lapeyian\resources\views/admin/unit-values/all.blade.php ENDPATH**/ ?>