<?php $__env->startSection('title','مدیریت واحد ها'); ?>
<?php $__env->startSection('pageTitle','فهرست واحد ها'); ?>

<?php $__env->startSection('content'); ?>


    <div class="row">
        <div class="col-md-4">
            <form action="<?php echo e(route('admin.units.store')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="card mb-5 mb-xl-8">
                    <!--begin::Header-->
                    <div class="card-header border-0 pt-5">
                        <h3 class="card-title align-items-start flex-column">
                            <span class="card-label fw-bolder fs-3 mb-1">ثبت واحد </span>
                        </h3>
                    </div>
                    <!--end::Header-->
                    <!--begin::Body-->
                    <div class="card-body py-3">
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo $__env->make('admin.__components.label', [ 'title' => 'عنوان ','required' => 1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <div
                                    class="mb-10 fv-row text-center fv-plugins-icon-container fv-plugins-bootstrap5-row-invalid">
                                    <?php echo $__env->make('admin.__components.input-text', [
                                        'name' => 'name',
                                        'placeholder' => 'عنوان '
                                       ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <?php echo $__env->make('admin.__components.label', [ 'title' => 'نوع ','required' => 1], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <div class="mb-10 fv-row text-center fv-plugins-icon-container fv-plugins-bootstrap5-row-invalid">
                                    <select class="form-control" id="exampleFormControlSelect1" name="base_unit">
                                        <option value="gram"> گرم</option>
                                        <option value="count">تعداد</option>
                                        <option value="liter">لیتر</option>
                                     </select>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="card-footer py-3 d-flex justify-content-end">
                        <button type="submit" class="btn btn-light-success">
                            <i class="fa fa-plus"></i>
                            ثبت واحد
                        </button>
                    </div>
                    <!--begin::Body-->
                </div>
            </form>
        </div>
        <div class="col-md-8">

            <div class="card mb-5 mb-xl-8">
                <!--begin::Header-->
                <div class="card-header border-0 pt-5">
                    <h3 class="card-title align-items-start flex-column">
                        <span class="card-label fw-bolder fs-3 mb-1">فهرست واحد ها</span>
                    </h3>

                </div>
                <!--end::Header-->
                <!--begin::Body-->
                <div class="card-body py-3">
                    <!--begin::Table container-->
                    <div class="table-responsive">
                        <!--begin::Table-->
                        <table class="table align-middle gs-0 gy-4">
                            <!--begin::Table head-->
                            <thead>
                            <tr class="fw-bolder text-muted bg-light">
                                <th class="min-w-50px ps-4 text-dark">#</th>
                                <th class="min-w-80px text-dark">عنوان</th>
                                <th class="min-w-80px text-dark">نوع</th>
                                <th class="min-w-125px rounded-end text-dark">عملیات</th>
                            </tr>
                            </thead>
                            <!--end::Table head-->
                            <!--begin::Table body-->
                            <tbody>

                            <?php if(count($units) > 0): ?>
                                <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <a href="#" class="text-dark fw-bolder
                                            text-hover-primary d-block mb-1 fs-6"><?php echo e($unit->id); ?></a>

                                        </td>
                                        <td>
                                            <a href="#" class="text-dark fw-bolder
                                            text-hover-primary d-block mb-1 fs-6"><?php echo e($unit->name); ?></a>
                                        </td>
                                        <td>
                                            <a href="#" class="text-dark fw-bolder
                                            text-hover-primary d-block mb-1 fs-6"><?php echo e($unit->base_unit); ?></a>
                                        </td>
                                        <td>
                                            
                                            <a href="<?php echo e(route('admin.units.edit', $unit)); ?>"
                                               class="btn btn-icon btn-light-info btn-sm me-1">
                                                    <span class="svg-icon svg-icon-3">
                                                        <i class="fa fa-edit"></i>
                                                    </span>
                                            </a>
                                            
                                            <a data-id=<?php echo e($unit->id); ?> href="javascript" class="btn btn-icon
                                                                        btn-light-danger btn-sm me-1 delete-confirm">
                                                      <span class="svg-icon svg-icon-3">
                                                        <i class="fa fa-trash"></i>
                                                      </span>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="7">
                                        <p class="text-danger text-center">اطلاعاتی ثبت نشده است</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                            <!--end::Table body-->
                        </table>
                        <!--end::Table-->
                    </div>

                <!--end::Table container-->
                </div>
                <!--begin::Body-->
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <!--Begin : SweetAlert Flash Messages -->
    <script>
        // success message
        <?php if((session('success'))): ?>
        Swal.fire({
            icon: 'success',
            title: 'عملیات موفق',
            text: "<?php echo e((session('success'))); ?>",
            confirmButtonText: "متوجه شدم"
        })
        <?php endif; ?>
        // error message
        <?php if((session('failed'))): ?>
        Swal.fire({
            icon: 'error',
            title: 'خطا',
            text: "<?php echo e(session('failed')); ?>",
            confirmButtonText: "متوجه شدم"
        })
        <?php endif; ?>
    </script>
    <!--End : SweetAlert Flash Messages -->


    <script>
        $('.delete-confirm').on('click', function (event) {
            event.preventDefault();
            let unit_id = $(this).data("id");
            let url = "<?php echo e(route('admin.units.delete',":unit_id")); ?>";
            url = url.replace(":unit_id", unit_id);

            Swal.fire({
                title: 'حذف  !',
                text: "آیا مطمئن هستید ؟",
                icon: "error",
                showCancelButton: true,
                confirmButtonColor: 'red',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'بله,حذف کن',
                cancelButtonText: 'خیر',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\lapeyian\resources\views/admin/units/all.blade.php ENDPATH**/ ?>