<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\IndexController;
use App\Http\Controllers\Frontend\ProductsController;
use App\Http\Controllers\Frontend\CommentsController;
use App\Http\Controllers\Frontend\BasketController;


/*----------app-----------*/

Route::group(['prefix' => ''], function () {

    Route::get('/', [IndexController::class, 'index'])->name('app.index');

    Route::get('/about', [IndexController::class, 'about'])->name('app.about');
    Route::get('/contact-us', [IndexController::class, 'contactUs'])->name('app.contactUs');
    Route::get('/products', [ProductsController::class, 'products'])->name('app.products');
    Route::get('/categories/{slug}', [ProductsController::class, 'categories'])->name('app.categories');
    Route::get('/product/{slug}', [ProductsController::class, 'single'])->name('app.single');
    Route::post('/comments/store/{productId}', [CommentsController::class, 'store'])->name('app.comments.store');

    Route::group(['prefix' => 'basket'], function () {

        Route::get('/', [BasketController::class, 'index'])->name('app.basket');
        Route::get('/add/{product}', [BasketController::class, 'add'])->name('app.basket.add');
        Route::get('/remove/{product}', [BasketController::class, 'remove'])->name('app.basket.remove');
        Route::get('/clear', [BasketController::class, 'clear'])->name('app.basket.clear');

    });
});
/*---------- app ------------*/
