<?php

use Illuminate\Support\Facades\Route;
use \App\Http\Controllers\Admin\DashboardController;
use \App\Http\Controllers\Admin\AdminsController;
use \App\Http\Controllers\Admin\profileController;
use App\Http\Controllers\Admin\TagsController;
use App\Http\Controllers\Admin\CategoriesController;
use App\Http\Controllers\Admin\CommentsController;
use App\Http\Controllers\Admin\UsersController;
use App\Http\Controllers\Admin\PostsController;
use App\Http\Controllers\Admin\ProductsController;
use App\Http\Controllers\Admin\ContactsController;
use App\Http\Controllers\Admin\UnitsController;
use App\Http\Controllers\Admin\UnitsValueController;
use App\Http\Controllers\Admin\ProductUnitPriceController;
use App\Http\Controllers\Admin\OrdersController;

/*----------admin-----------*/

Route::group(['prefix' => '', 'middleware' => 'auth.admin'], function () {

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
    //Profile
    Route::group(['prefix' => 'profile'], function () {
        Route::get('/', [ProfileController::class, 'index'])->name('admin.profile.index');
        Route::post('/update', [ProfileController::class, 'update'])->name('admin.profile.update');

    });
    //Admins
    Route::group(['prefix' => 'admins'], function () {
        Route::get('/', [AdminsController::class, 'index'])->name('admin.admins.all');
        Route::get('/create', [AdminsController::class, 'create'])->name('admin.admins.create');
        Route::post('/store', [AdminsController::class, 'store'])->name('admin.admins.store');
        Route::get('/edit/{admin}', [AdminsController::class, 'edit'])->name('admin.admins.edit');
        Route::post('/update/{admin}', [AdminsController::class, 'update'])->name('admin.admins.update');
        Route::get('/logical-deletion/{admin}', [AdminsController::class, 'logicalDeletion'])->name('admin.admins.logicalDeletion');
    });
    // users
    Route::group(['prefix' => 'users'], function () {
        Route::get('/', [UsersController::class, 'index'])->name('admin.users.all');
        Route::get('/delete/{user}', [UsersController::class, 'delete'])->name('admin.users.delete');
    });

    // tags
    Route::group(['prefix' => 'tags'], function () {
        Route::get('/', [TagsController::class, 'index'])->name('admin.tags.all');
        Route::post('/store', [TagsController::class, 'store'])->name('admin.tags.store');
        Route::get('/edit/{tag}', [TagsController::class, 'edit'])->name('admin.tags.edit');
        Route::post('/update/{tag}', [TagsController::class, 'update'])->name('admin.tags.update');
        Route::get('/delete/{tag}', [TagsController::class, 'delete'])->name('admin.tags.delete');
        Route::get('/search/ajax', [TagsController::class, 'searchWithAjax'])->name('admin.tags.search.ajax');
    });

    //Categories
    Route::group(['prefix' => 'categories/{entity}'], function () {

        Route::get('/', [CategoriesController::class, 'index'])->name('admin.categories.all');
        Route::get('/create', [CategoriesController::class, 'create'])->name('admin.categories.create');
        Route::post('/store', [CategoriesController::class, 'store'])->name('admin.categories.store');
        Route::get('/edit/{category}', [CategoriesController::class, 'edit'])->name('admin.categories.edit');
        Route::post('/update/{category}', [CategoriesController::class, 'update'])->name('admin.categories.update');
        Route::get('/delete/{category}', [CategoriesController::class, 'delete'])->name('admin.categories.delete');
        Route::get('/ajax-search', [CategoriesController::class, 'ajaxSearch'])->name('admin.categories.ajax.search');
    });

    // comments
    Route::group(['prefix' => 'comments'], function () {
        Route::get('/', [CommentsController::class, 'index'])->name('admin.comments.all');
        Route::post('/update/{comment}', [CommentsController::class, 'update'])->name('admin.comments.update');
    });

    // posts
    Route::group(['prefix' => 'posts'], function () {
        Route::get('/', [PostsController::class, 'index'])->name('admin.posts.all');
        Route::get('/create', [PostsController::class, 'create'])->name('admin.posts.create');
        Route::post('/store', [PostsController::class, 'store'])->name('admin.posts.store');
        Route::get('/edit/{post}', [PostsController::class, 'edit'])->name('admin.posts.edit');
        Route::post('/update/{post}', [PostsController::class, 'update'])->name('admin.posts.update');
        Route::get('/delete/{post}', [PostsController::class, 'delete'])->name('admin.posts.delete');
        Route::get('/comments/{post}', [PostsController::class, 'comments'])->name('admin.posts.comments');
    });
    // products
    Route::group(['prefix' => 'products'], function () {
        Route::get('/', [ProductsController::class, 'index'])->name('admin.products.all');
        Route::get('/create', [ProductsController::class, 'create'])->name('admin.products.create');
        Route::post('/store', [ProductsController::class, 'store'])->name('admin.products.store');
        Route::get('/edit/{product}', [ProductsController::class, 'edit'])->name('admin.products.edit');
        Route::post('/update/{product}', [ProductsController::class, 'update'])->name('admin.products.update');
        Route::get('/delete/{product}', [ProductsController::class, 'delete'])->name('admin.products.delete');
        Route::get('/comments/{product}', [ProductsController::class, 'comments'])->name('admin.products.comments');
        Route::get('/gallery/{product}', [ProductsController::class, 'gallery'])->name('admin.products.gallery');
        Route::post('/upload-gallery/{product}', [ProductsController::class, 'uploadGallery'])->name('admin.products.upload-gallery');
        Route::get('/upload-delete/{gallery}', [ProductsController::class, 'deleteGallery'])->name('admin.products.delete-gallery');

        //ProductUnitPrice
        Route::group(['prefix' => 'ProductUnitPrice'], function () {
            Route::get('/{product}', [ProductUnitPriceController::class, 'index'])->name('admin.products.ProductUnitPrice.index');
            Route::post('/store/{product}', [ProductUnitPriceController::class, 'store'])->name('admin.products.ProductUnitPrice.store');


        });
    });


     //contacts
     Route::group(['prefix' => 'contacts'], function () {
        Route::get('/', [ContactsController::class, 'index'])->name('admin.contacts.all');
    });

    //units
    Route::group(['prefix' => 'units'], function () {
        Route::get('/', [UnitsController::class, 'index'])->name('admin.units.all');
        Route::post('/store', [UnitsController::class, 'store'])->name('admin.units.store');
        Route::get('/edit/{unit}', [UnitsController::class, 'edit'])->name('admin.units.edit');
        Route::post('/update/{unit}', [UnitsController::class, 'update'])->name('admin.units.update');
        Route::get('/delete/{unit}', [UnitsController::class, 'delete'])->name('admin.units.delete');

    });
    //UnitsValue
    Route::group(['prefix' => 'UnitsValue'], function () {
        Route::get('/', [UnitsValueController::class, 'index'])->name('admin.UnitsValue.all');
        Route::post('/store', [UnitsValueController::class, 'store'])->name('admin.UnitsValue.store');
        Route::get('/delete/{unitValue}', [UnitsValueController::class, 'delete'])->name('admin.UnitsValue.delete');

    });



    //orders
    Route::group(['prefix' => 'orders'], function () {
        Route::get('/', [OrdersController::class, 'index'])->name('admin.orders.all');

    });

});
/*---------- app ------------*/
