<!doctype html>
<html lang="fa-IR" dir="rtl">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <link rel="stylesheet" href="{{asset('assets/css/dependencies/swiper.min.css')}}" />

    <link rel="stylesheet" href="{{asset('assets/css/reset.css')}}" />
    <link rel="stylesheet" href="{{asset('assets/css/fonts.css')}}" />
    <link rel="stylesheet" href="{{asset('assets/css/base.css')}}" />
    <link rel="stylesheet" href="{{asset('assets/css/app.css')}}" />
    <link rel="stylesheet" href="{{asset('assets/css/dependencies/nouislider.min.css')}}"/>

    @yield('style')

    <script src="{{asset('assets/scripts/mount.js')}}"></script>
    <script defer src="{{asset('assets/scripts/dependencies/flowbite.min.js')}}"></script>
    <script defer src="{{asset('assets/scripts/dependencies/swiper.min.js')}}"></script>
    <script defer src="{{asset('assets/scripts/dependencies/nouislider.min.js')}}"></script>

    <script defer src="{{asset('assets/scripts/theme.js')}}"></script>
    <script defer src="{{asset('assets/scripts/header/indicator.js')}}"></script>
    <script defer src="{{asset('assets/scripts/header/search.js')}}"></script>
    <script defer src="{{asset('assets/scripts/header/magaMenu.js')}}"></script>
    <script defer src="{{asset('assets/scripts/scroll.js')}}"></script>
    <script defer src="{{asset('assets/scripts/app.js')}}"></script>
    <script defer src="{{asset('assets/scripts/swiper.js')}}"></script>

    <title> @yield('title') </title>
</head>

<body>
<div class="flex min-h-screen flex-col">

    @include('app.partials.header')

    @yield('content')

    @include('app.partials.footer')

    <div
        data-onscrollclass="translate-y-full"
        class="bg-muted fixed inset-x-0 bottom-0 z-20 duration-300 lg:hidden"
    >
        <div class="container flex items-center text-sm">
            <div
                class="border-primary text-primary w-1/4 border-b-2 py-1 font-medium"
            >
                <a
                    href="{{route('app.index')}}"
                    class="flex flex-col items-center justify-center"
                >
                    <i
                        class="i-solar-home-smile-linear size-6 items-center justify-center"
                    ></i>
                    <p class="xs:text-sm pt-2 text-xs">خانه</p>
                </a>
            </div>
            <div class="w-1/4 py-1">
                <a
                    href=""
                    class="flex flex-col items-center justify-center"
                >
                    <i class="i-iconamoon-category-light size-6"></i>
                    <p class="xs:text-sm pt-2 text-xs">دسته ها</p>
                </a>
            </div>
            <div class="w-1/4 py-1">
                <a
                    href="{{route('app.basket')}}"
                    class="flex flex-col items-center justify-center"
                >
                    <i class="i-lucide-shopping-cart size-6"></i>
                    <p class="xs:text-sm pt-2 text-xs">سبد خرید</p>
                </a>
            </div>
            <div class="w-1/4 py-1">
                <a
                    href=""
                    class="flex flex-col items-center justify-center"
                >
                    <i class="i-lucide-user-round size-6"></i>
                    <p class="xs:text-sm pt-2 text-xs">حساب من</p>
                </a>
            </div>
        </div>
    </div>
</div>

</body>
</html>
@yield('scripts')
