@extends('layouts.admin.admin')

@section('title','مدیریت تگ ها')
@section('pageTitle','ثبت تگ جدید')

@section('content')


    <div class="row">
        <div class="col-md-4">
            <form action="{{route('admin.tags.store')}}" method="post">
                @csrf
                <div class="card mb-5 mb-xl-8">
                    <!--begin::Header-->
                    <div class="card-header border-0 pt-5">
                        <h3 class="card-title align-items-start flex-column">
                            <span class="card-label fw-bolder fs-3 mb-1">ثبت تگ </span>
                        </h3>
                    </div>
                    <!--end::Header-->
                    <!--begin::Body-->
                    <div class="card-body py-3">
                        <div class="row">
                            <div class="col-md-12">
                                @include('admin.__components.label', [ 'title' => 'نام تگ','required' => 1])
                                <div
                                    class="mb-10 fv-row text-center fv-plugins-icon-container fv-plugins-bootstrap5-row-invalid">
                                    @include('admin.__components.input-text', [
                                        'name' => 'name',
                                        'placeholder' => 'نام تگ'
                                       ])
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="card-footer py-3 d-flex justify-content-end">
                        <button type="submit" class="btn btn-light-success">
                            <i class="fa fa-plus"></i>
                            ثبت تگ
                        </button>
                    </div>
                    <!--begin::Body-->
                </div>
            </form>
        </div>
        <div class="col-md-8">

            <div class="card mb-5 mb-xl-8">
                <!--begin::Header-->
                <div class="card-header border-0 pt-5">
                    <h3 class="card-title align-items-start flex-column">
                        <span class="card-label fw-bolder fs-3 mb-1">فهرست تگ ها</span>
                        <span class="text-muted mt-1 fw-bold fs-7 mt-5">تعداد تگ ها : <span
                                class="badge badge-primary">{{count($tags)}}</span></span>
                    </h3>

                </div>
                <!--end::Header-->
                <!--begin::Body-->
                <div class="card-body py-3">
                    <!--begin::Table container-->
                    <div class="table-responsive">
                        <!--begin::Table-->
                        <table class="table align-middle gs-0 gy-4">
                            <!--begin::Table head-->
                            <thead>
                            <tr class="fw-bolder text-muted bg-light">
                                <th class="min-w-50px ps-4">#</th>
                                <th class="min-w-80px">نام</th>
                                <th class="min-w-125px  rounded-end">عملیات</th>
                            </tr>
                            </thead>
                            <!--end::Table head-->
                            <!--begin::Table body-->
                            <tbody>

                            @if(count($tags) > 0)
                                @foreach($tags as $tag)
                                    <tr>
                                        <td>
                                            <a href="#" class="text-dark fw-bolder
                                            text-hover-primary d-block mb-1 fs-6">{{$tag->id}}</a>

                                        </td>
                                        <td>
                                            <a href="#" class="text-dark fw-bolder
                                            text-hover-primary d-block mb-1 fs-6">{{$tag->name}}</a>
                                        </td>
                                        <td>
                                            {{-- edit--}}
                                            <a href="{{ route('admin.tags.edit', $tag) }}"
                                               class="btn btn-icon btn-light-info btn-sm me-1">
                                                    <span class="svg-icon svg-icon-3">
                                                        <i class="fa fa-edit"></i>
                                                    </span>
                                            </a>
                                            {{-- delete--}}
                                            <a data-id={{ $tag->id }} href="javascript" class="btn btn-icon
                                                                        btn-light-danger btn-sm me-1 delete-confirm">
                                                      <span class="svg-icon svg-icon-3">
                                                        <i class="fa fa-trash"></i>
                                                      </span>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="7">
                                        <p class="text-danger text-center">اطلاعاتی ثبت نشده است</p>
                                    </td>
                                </tr>
                            @endif
                            </tbody>
                            <!--end::Table body-->
                        </table>
                        <!--end::Table-->
                    </div>
                {!! $tags->render() !!}
                <!--end::Table container-->
                </div>
                <!--begin::Body-->
            </div>
        </div>
    </div>

@endsection

@section('scripts')
    <!--Begin : SweetAlert Flash Messages -->
    <script>
        // success message
        @if((session('success')))
        Swal.fire({
            icon: 'success',
            title: 'عملیات موفق',
            text: "{{ (session('success'))}}",
            confirmButtonText: "متوجه شدم"
        })
        @endif
        // error message
        @if((session('failed')))
        Swal.fire({
            icon: 'error',
            title: 'خطا',
            text: "{{session('failed')}}",
            confirmButtonText: "متوجه شدم"
        })
        @endif
    </script>
    <!--End : SweetAlert Flash Messages -->


    <script>
        $('.delete-confirm').on('click', function (event) {
            event.preventDefault();
            let tag_id = $(this).data("id");
            let url = "{{ route('admin.tags.delete',":tag_id") }}";
            url = url.replace(":tag_id", tag_id);

            Swal.fire({
                title: 'حذف  !',
                text: "آیا مطمئن هستید ؟",
                icon: "error",
                showCancelButton: true,
                confirmButtonColor: 'red',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'بله,حذف کن',
                cancelButtonText: 'خیر',
                reverseButtons: true
            }).then((result) => {
                if (result.value) {
                    window.location.href = url;
                }
            });
        });
    </script>

@endsection
