@extends('layouts.admin.admin')
@section('content')
    @include('admin.products.index',[
        'active' =>'edit'
])
    <div id="kt_content_container" class="container-xxl">
         <form class="form" action="{{route('admin.products.update',$product)}}" method="post"
          enctype="multipart/form-data">
        @csrf
        <div class="card card-flush py-4">
            <!--begin::Card header-->
            <div class="card-header">
                <div class="card-title">
                    <h2>ویرایش محصول</h2>
                </div>
                <div class="card-toolbar">
                    <a href="{{route('admin.products.all')}}" class="btn btn-sm btn-light-success "
                       style="margin-left: 5px">
                        بازگشت
                    </a>

                </div>
            </div>
            <!--end::Card header-->

            <div class="card-body pt-0 mt-2">
                <div class="row">
                    <div class="col-md-8 p-5">

                        <div class="row">
                            <div class="col-md-6">
                                <div
                                    class="mb-10 fv-row fv-plugins-icon-container fv-plugins-bootstrap5-row-invalid">
                                    @include('admin.__components.label', [ 'title' => ' عنوان محصول'])
                                    @include('admin.__components.input-text', [
                                        'name' => 'title',
                                        'value'=> $product->title,
                                        ])
                                </div>
                            </div>


                            <div class="col-md-6">
                                <div
                                    class="mb-10 fv-row fv-plugins-icon-container fv-plugins-bootstrap5-row-invalid">
                                    @include('admin.__components.label', [ 'title' => 'تگ ها'])
                                    @include('admin.__components.select-2-ajax', [
                                        'name' => 'tags',
                                        'isMultiple' => true,
                                        'url' => route('admin.tags.search.ajax'),
                                          'selectedItems' => $product->tags()->get(['tag_id as id','name as title']),
                                        ])
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-10 fv-row fv-plugins-icon-container">
                                    @include('admin.__components.label',['title' => 'توضیحات کوتاه','required' => true])
                                    <div class="mb-5">
                                        @include('admin.__components.textarea', [
                                                'name' => 'short_description',
                                                'value' => $product->short_description
                                                ])
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-10 fv-row fv-plugins-icon-container">
                                    @include('admin.__components.label',['title' => 'توضیحات','required' => true])
                                    <div class="mb-5">
                                        @include('admin.__components.ckeditor', [
                                                'name' => 'description',
                                                'value' => $product->description
                                                ])
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex flex-end">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-plus"></i>
                                <span class="indicator-label">ویرایش محصول</span>
                            </button>
                        </div>
                    </div>
                    <div class="col-md-4 p-5" style="background-color: #dfdddd3d">
                        <div class="d-flex flex-column">
                            <div class="card card-flush mb-5">
                                <!--begin::Card header-->
                                <div class="card-header">
                                    <!--begin::Card title-->
                                    <div class="card-title">
                                        <h4>وضعیت</h4>
                                    </div>
                                    <!--end::Card title-->
                                </div>
                                <!--end::Card header-->
                                <!--begin::Card body-->

                                <div class="card-body pt-0">

                                    @include('admin.__components.horizontal-radiobutton', [
                                    'activeKey' =>$product->status ,
                                    'name' => 'status',
                                    'items' => $statuses
                                   ])
                                </div>
                                <!--end::Card body-->
                            </div>

                            <div class="card card-flush">
                                <!--begin::Card header-->
                                <div class="card-header">
                                    <!--begin::Card title-->
                                    <div class="card-title">
                                        <h4>تصویر</h4>
                                    </div>
                                    <!--end::Card title-->
                                </div>
                                <!--end::Card header-->
                                <!--begin::Card body-->
                                <div class="card-body text-center pt-0">
                                    @include('admin.__components.image-input', [
                                                'name' => 'image',
                                                'imageUrl'=>$product->webPresent()->image
                                                ])
                                </div>
                                <!--end::Card body-->
                            </div>


                            <div class="card card-flush py-4 mb-5">
                                <div class="card-header">
                                    <div class="card-title">
                                        <h2>دسته بندی </h2>
                                    </div>
                                </div>
                                <div class="card-body text-center pt-0">
                                    @include('admin.__components.jsTree',
                                         [
                                            'name' => 'categories',
                                            'items' => $categories,
                                            'isMultiple' => true,
                                            'isEdit' => true,
                                        ])
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    </div>
@endsection
@section('scripts')
@include('admin.message.alert');
@endsection
@section('style')

    <link rel="stylesheet" href="{{asset('admin-assets/plugins/custom/jstree/jstree.bundle.rtl.css')}}"/>
@endsection
@section('top-scripts')

    <script src="{{asset('admin-assets/plugins/custom/jstree/jstree.bundle.js')}}"></script>
@endsection
