<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to your application's "home" route.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/home';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     */
    public function boot()
    {
        $this->configureRateLimiting();

        $this->routes(function () {

            //admin
            Route::middleware('web')
                ->namespace($this->namespace)
                ->prefix('admin')
                ->group(base_path('routes/admin/web.php'));


            //auth/admin
            Route::middleware('web')
                ->namespace($this->namespace)
                ->prefix('auth/admin')
                ->group(base_path('routes/admin/auth.php'));

            // app
            Route::middleware('web')
                ->namespace($this->namespace)
                ->group(base_path('routes/app/web.php'));


            //login/app
            Route::middleware('web')
                ->namespace($this->namespace)
                ->prefix('auth/')
                ->group(base_path('routes/app/auth.php'));


        });
    }
    protected function configureRateLimiting()
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by(optional($request->user())->id ?: $request->ip());
        });
    }
}
