<?php


namespace App\Presenters\Web\Post;


use App\Constants\Constant;
use App\Models\User;
use App\Presenters\Contracts\Presenter;
use Illuminate\Support\Facades\DB;

class PostPresenter extends Presenter
{
    public function image()
    {

        if (is_null($this->entity->image) || $this->entity->image == "") {
            return asset('admin-assets/media/avatars/blank.png');
        }
        return str_replace('\\', '/', asset(Constant::POSTS_AVATAR_PATH . DIRECTORY_SEPARATOR . $this->entity->image));
    }

    public function user()
    {
        if (!is_null($this->entity->user_id)) {
            return $this->entity->user->first_name.$this->entity->user->last_name;
        }
    }
    public function getUser()
    {

        if (!is_null($this->entity->user_id)) {
            return User::select('id', DB::raw("CONCAT(users.first_name,' ',users.last_name) as title"))
                ->where('id', $this->entity->user_id)->get();
        }
    }

    public function status()
    {
        $status = "";
        if (!is_null($this->entity->status)) {
            if ($this->entity->status == Constant::PUBLISHED) {
                return " <div class='badge badge-light-success'>تایید شده</div>";
            } elseif ($this->entity->status == Constant::DRAFT) {
                return "  <div class='badge badge-light-danger'> رد شده </div>";
            }
        }
        return $status;
    }

    public function fullName()
    {
        return $this->entity->first_name . ' ' . $this->entity->last_name;
    }


}
