<?php

namespace App\Http\Controllers\Frontend;

use App\Constants\Constant;
use App\Filters\ProductsFilter;
use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Product;
use Illuminate\Http\Request;

class ProductsController extends Controller
{

    public function products(): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {
        $products = Product::filter(new ProductsFilter())->where('status', 'active')->get();
        $categories = Category::query()->where('entity', Constant::SHOP)->where('status', 'active')->get();
        return view('app.products', compact('products', 'categories'));

    }

    public function categories(string $slug): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application|\Illuminate\Http\RedirectResponse
    {
        $category = Category::query()->where('entity', Constant::SHOP)->where('slug', $slug)->first();
        if ($category == null) {
            return redirect()->route('app.index');
        }
        $categories = Category::query()->where('entity', Constant::SHOP)->where('status', 'active')->get();
        $products = $category->products;
        return view('app.products', compact('products', 'categories','category'));
    }

    public function single(string $slug): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application|\Illuminate\Http\RedirectResponse
    {

        $product = Product::with('comments', 'tags')->where('slug', $slug)->first();

        if ($product == null) {
            return redirect()->route('app.products');
        }

        $categories = Category::query()->where('entity', Constant::SHOP)->where('status', 'active')->get();
        $comments = $product->comments()->where('status', Constant::CONFIRMED)->get();

        return view('app.single', compact('product', 'categories', 'comments'));
    }
}
