<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Comment;

class CommentsController
{
    public function store(int $productId): \Illuminate\Http\RedirectResponse
    {
        $model = Comment::getEntity('shop');
        $entity = $model::where('id', $productId)->first();

        $entity->comments()->create([
            'user_id' => auth('web')->user()->id,
            'parent_id' => (request()->has('parent_id')) ? request('parent_id') : null,
            'title' => request('title'),
            'text' => request('body'),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);

        return redirect()->back()->with('store', 'نظر شما با موفقیت ثبت شد و پس از تایید به نمایش در خواهد آمد');

    }
}
