<?php

namespace App\Http\Controllers\Auth\app;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class LoginController extends Controller
{
    public function showLoginForm(): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {

        return view('auth.app.login');
    }

    public function login(Request $request): \Illuminate\Http\RedirectResponse
    {

//        $request->validate([
//            'mobile' => ['required', 'exists:users'],
//            'password' => ['required'],
//        ], [
//            'mobile.required' => 'وارد کردن  شماره موبایل الزامی است ',
//            'mobile.exists' => 'شماره موبایل  موجود نمی باشد',
//            'password.required' => 'وارد کردن پسورد الزامی است ',
//        ]);


        $user = User::query()->where('mobile', $request->input('mobile'))->first();


        if ($user instanceof User) {

            if (!Hash::check($request->input('password'), $user['password'])) {
                return redirect()->back()->with('failed', 'اطلاعات ورود صحیح نمیباشد');
            }


            Auth::guard('web')->login($user);

            return redirect()->route('app.index');
        }

        return redirect()->back()->with('failed', 'اطلاعات ورود صحیح نمیباشد');

    }
    public function logout(): \Illuminate\Http\RedirectResponse
    {
        Auth::guard('web')->logout();
        return redirect()->route('app.index');
    }
}
