<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\ProductUnitPrice;
use App\Models\UnitValue;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class ProductUnitPriceController extends BaseController
{
    public function index(Product $product): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {
        $unitValues = UnitValue::with('unit')->get();
        $prices = ProductUnitPrice::query()->where('product_id',$product->id)->with(['product','unitValue'])->latest()->get();

        return view('admin.products.product-unit-prices.index',
            compact('product','unitValues','prices'));
    }
    public function store(Request $request,Product $product): \Illuminate\Http\RedirectResponse
    {
        $request->validate([
            'unit_value_id' => 'required|exists:unit_values,id',
            'price'         => 'required|numeric|min:0',
            'inventory'     => 'nullable|numeric|min:0',
        ]);


        $exists = ProductUnitPrice::query()->where('product_id', $product->id)
            ->where('unit_value_id', $request->unit_value_id)
            ->exists();

        if ($exists) {
            return back()->with('error', 'برای این محصول و این مقدار قبلاً قیمت ثبت شده است.');
        }

        ProductUnitPrice::query()->create([
            'product_id'    => $product->id,
            'unit_value_id' => $request->input('unit_value_id'),
            'price'         => $request->input('price'),
            'inventory'     => $request->input('inventory'),
        ]);

        return back()->with('success', 'قیمت ثبت شد');
    }


}
