<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Comment;
use Illuminate\Http\Request;

class CommentsController extends Controller
{
    public function index(): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\Foundation\Application
    {
        $comments = Comment::paginate();
        return view('admin.comments.all', compact('comments'));
    }

    public function update(Request $request, Comment $comment)
    {

        $data = ['status' => $request->status];
        $result = $comment->update($data);
        if ($result) {
            return redirect()->back()->with('update','وضعیت نظر شما با موفقیت تغیر کرد');
        } else {
            return redirect()->back();
        }
    }
}
